/****** Object:  View [dbo].[V_EST_PROD_INVENTARIO]    Script Date: 04/11/2013 10:05:53 ******/
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[V_EST_PROD_INVENTARIO]'))
DROP VIEW [V_EST_PROD_INVENTARIO]
GO
GO
GO

CREATE VIEW [V_EST_PROD_INVENTARIO]
AS
SELECT  DISTINCT   
	PRC_FILIAL.CD_EMP, 
	PRC_FILIAL.CD_FILIAL, 
	PRC_FILIAL.RZ_FILIAL, 
	PRC_FILIAL.CGC, 
	PRC_FILIAL.INSC_EST, 
    EST_PROD_INVENTARIO.DT_REF, 
	EST_PROD_INVENTARIO.CD_PROD, 
	EST_PROD.DS_PROD, 
	EST_PROD_UN_MED.DS_UN, 
    EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA CD_SC, 
	EST_PROD_INVENTARIO.QT_EST, 
	EST_PROD_INVENTARIO.VLR_PROD, 
    EST_PROD_INVENTARIO.QT_EST * EST_PROD_INVENTARIO.VLR_PROD AS VLR_PROD_TOT, 
                      CASE WHEN ICMS = 1 THEN ((EST_PROD_INVENTARIO.QT_EST * EST_PROD_INVENTARIO.VLR_PROD) 
                      * T.PERC_ICMS_EST) / 100 ELSE 0 END AS VLR_ICMS, 
                      CASE WHEN T.ISENTO = 1 THEN 0 WHEN ICMS = 1 THEN ISNULL(T.PERC_ICMS_EST,
                       0) WHEN T.SUBS_TRIB <> 1 AND 
                      ICMS_RD = 1 THEN ISNULL(T.PERC_ICMS_EST, 0) 
                      WHEN T.SUBS_TRIB = 1 THEN 0 WHEN T.SUBS_TRIB_ANT = 1 THEN 0 ELSE
                       0 END AS PERC_ICMS_EST, 
                      CASE WHEN T.ISENTO = 1 THEN '(I) ISENTO' WHEN ICMS = 1 THEN '(T) TRIBUTADOS' WHEN T.SUBS_TRIB
                       <> 1 AND 
                      ICMS_RD = 1 THEN '(T) TRIBUTADOS' WHEN T.SUBS_TRIB = 1 THEN '(F) SUBS.TRIBUT' WHEN T.SUBS_TRIB_ANT
                       = 1 THEN '(F) SUBS.TRIBUT' ELSE '(S) SEM CLASSIFICAO' END AS GRP_TRIB, EST_PROD_INVENTARIO.DT_CAD,
   EST_PROD.NR_NCM
FROM        

	EST_PROD_INVENTARIO
	inner join  PRC_FILIAL  on 
	EST_PROD_INVENTARIO.CD_EMP	 = PRC_FILIAL.CD_EMP AND 
	EST_PROD_INVENTARIO.CD_FILIAL = PRC_FILIAL.CD_FILIAL 

	LEFT  JOIN V_EST_PROD_CPL_TRIB_EST_VENDAS  T ON 
	EST_PROD_INVENTARIO.CD_EMP    = T.CD_EMP AND 
	EST_PROD_INVENTARIO.CD_FILIAL = T.CD_FILIAL AND 
	EST_PROD_INVENTARIO.CD_PROD   = T.CD_PROD

	INNER JOIN EST_PROD ON 
	EST_PROD_INVENTARIO.CD_EMP = EST_PROD.CD_EMP AND 
	EST_PROD_INVENTARIO.CD_PROD = EST_PROD.CD_PROD

	LEFT OUTER JOIN EST_PROD_UN_MED  ON
	EST_PROD.CD_EMP		= EST_PROD_UN_MED.CD_EMP AND 
	EST_PROD.CD_UN_VD	= EST_PROD_UN_MED.CD_CTR_UN
	
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON 	
	EST_PROD.CD_EMP  = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP AND
	EST_PROD.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD
GO


